close all % Close all figures
fclose('all'); % Close all files
fid = fopen('data/TABLE4.dat','w');
   N = 33;
   dt = (1/30)*10^6;

%  The printing Format
   format = [];
   format = [format,'%3.0f']; % experiment number
   format = [format,' & '];
   format = [format,'%6.2f']; % D
   format = [format,' & '];
   format = [format,'%6.2f']; % White
   format = [format,' & '];
   format = [format,'%6.2f']; % Chi
   format = [format,' & '];
   format = [format,'%6.2f']; % D1 liner
   format = [format,' & '];
   format = [format,'%6.2f']; % D2 liner
   format = [format,' & '];
   format = [format,'%6.2f']; % D3 power-law
   format = [format,' & '];
   format = [format,'%6.2f']; % D4 power-law
   format = [format, '\\\\\n'];

%  Print the Number of the columns.
   K = 7; % Number of columns.
   for k = 1:K-1
      fprintf(fid, '%3.0f & ', k);
   end
   fprintf(fid,'%3.0f ', K);
   fprintf(fid,'\\\\\n');

%  Print the column numbers
   header = [];
   header = [header,'\\#']; %1
   header = [header,' & '];
   header = [header,'$D$']; %2
   header = [header,' & '];
   header = [header,'$D^\\chi$']; %4
   header = [header,' & '];
   header = [header,'$D^W$']; %5
   header = [header,' & '];
   header = [header,'$D_1$']; %6
   header = [header,' & '];
   header = [header,'$D_2$']; %7
   header = [header,' & '];
   header = [header,'$D_3$']; %8
   header = [header,' & '];
   header = [header,'$D_4$']; %9
   header = [header,' \\\\\n'];
   fprintf(fid,header);
   fprintf(fid,'\\hline \n');

%  Read the parameters data.
   Data = dlmread('data/Estimates.data','',1,0);
   Simple = dlmread('data/SimpleStats.data','',1,0);
   White = dlmread('data/White.data','',1,0);
   Param = dlmread('data/Parameters.data','',1,0);

   ratio = [];
for i=1:N+1
   M2 = Simple(i,7);
   M2W  = White(i,4);
   lambda = Param(i,6);
   k = Param(i,7);
   M2Chi  = lambda^2*gamma(1+2/k);
   M2Chi  = lambda^2*k;
   A1 = Data(i,2);
   B1 = Data(i,3);
   R1 = Data(i,4);
   A2 = Data(i,5);
   R2 = Data(i,6);
   a1 = Data(i,7);
   b1 = Data(i,8);
   r1 = Data(i,9);
   a2 = Data(i,10);
   r2 = Data(i,11);
   alpha1 = Data(i,12);
   alpha2 = Data(i,13);
   out = [M2, M2Chi, M2W, A1, A2, a1*alpha1, a2*alpha2];
   out = [i, 100*out/(4*dt)];
%  Print the results table.
   fprintf(fid,format,out);
   if (i == 4 | i == 8 | i == 12 |i == 16 |i == 20 | i == 25 | i == 30)
	fprintf(fid,'\\hline \n');
   end
end
